var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"MAYAUL\">\n      <meta name=\"release\" content=\"2016\">\n      <meta name=\"book\" content=\"Tutorial\">\n      <meta name=\"created\" content=\"2015-10-30\">\n      <meta name=\"topicid\" content=\"GUID-5D759C37-29A2-419B-8138-773D3CC3BBCF\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <title>Creating the nParticle slag</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-5D759C37-29A2-419B-8138-773D3CC3BBCF\"></a><div class=\"head\">\n            <h1>Creating the nParticle slag</h1>\n         </div>\n         <p><a name=\"WS73099CC142F48755-191A86AC126720FA35435E5\"></a>To create the nParticle object that simulates the slag flow, you use the \n            		<span class=\"MenuCascade\" id=\"GUID-00202AA7-5302-41AB-A9C9-C81AB7CD8436\">Ball</span> type nParticles. Note that later in the lesson, you convert the nParticle object\n            to an output mesh. \n            	 \n         </p><a name=\"WS73099CC142F48755-191A86AC126720FA35435E6\"></a><p class=\"list-intro\"><a name=\"WS73099CC142F48755-191A86AC126720FA35435E7\"></a>To create the nParticle object\n         </p>\n         <ol type=\"1\" start=\"1\">\n            <li>Set the nParticle type to \n               		  <span class=\"MenuCascade\" id=\"GUID-C1AD4C26-3D2E-4681-87D5-15C93D49A563\">Balls</span> by selecting \n               		  <span class=\"MenuCascade\" id=\"GUID-31544C9B-1526-4C60-AB25-56C074D0F0C0\">nParticles &gt; Create Options &gt; Balls</span>. \n               		  <a name=\"FIG_C6F53A447C014390A40DB0773559FC66\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-62C331B7-4237-46ED-B208-F61B53E584D6-low.png\"></div> \n            </li>\n            <li>Create the nParticle and emitter objects by selecting \n               		  <span class=\"MenuCascade\" id=\"GUID-4D9BA3CE-2FBD-439D-8512-35DEE1F06AAD\">nParticles &gt; Create Emitter</span> &gt; \n               		  <img src=\"../images/GUID-D0B559A1-42F8-4DFC-BBE6-7EC64945DB21-low.png\">. \n               		\n            </li>\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-78802C75-00BC-4FF9-82F3-318E64A2C1FE\">Emitter Options (Create)</span> window, reset to the default values by selecting \n               		  <span class=\"MenuCascade\" id=\"GUID-4CFB415C-A89C-4F66-A1E1-D2C2C77CE914\">Edit &gt; Reset Settings</span> and do the following: \n               		  <a name=\"WS73099CC142F48755-191A86AC126720FA35435EB\"></a><ul>\n                  <li>For \n                     				<span class=\"MenuCascade\" id=\"GUID-EC2346D5-20B1-4D4A-AC40-0E4DBA7BA46F\">Emitter name</span>, type \n                     				<em class=\"mild\">emitter_slag</em>. \n                     			 \n                  </li>\n                  <li>If the \n                     				<span class=\"MenuCascade\" id=\"GUID-1690E7E5-FF5A-47DD-9E22-EA399CC59C53\">Solver</span> list appears, select nucleus1. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-4F4944EA-CBAE-4914-B2D9-5FDCE49D42F2\">Basic Emitter Attributes</span> section, set \n                     				<span class=\"MenuCascade\" id=\"GUID-404017D8-E540-4DFF-A1F4-957E1BAA943F\">Emitter type</span> to \n                     				<span class=\"MenuCascade\" id=\"GUID-80BA4B14-6B6E-44F0-BABE-E4BCCE99FEAD\">Volume</span>. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-3EDF173B-A942-4AA6-AAEA-2BC3CC753171\">Volume Emitter Attributes</span> section, select \n                     				<span class=\"MenuCascade\" id=\"GUID-85CAE442-2C0D-464C-BC89-5B4DC6256DAF\">Sphere</span> from the \n                     				<span class=\"MenuCascade\" id=\"GUID-6F7316EB-BF1B-4DDC-A52E-FB21640CFF65\">Volume shape</span> list. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-4650B0E8-0A9C-42D9-952B-F5E082E8C8A6\">Volume Speed Attributes</span> section, set \n                     				<span class=\"MenuCascade\" id=\"GUID-B2A9FDE6-2EEE-4E5C-86EC-E959C4C8136D\">Away from center</span> to 0 and \n                     				<span class=\"MenuCascade\" id=\"GUID-5BAFB569-0A0C-4CAF-8605-EDE9F159EB03\">Directional speed</span> to 5.0. \n                     			 \n                  </li>\n               </ul> \n            </li>\n            <li>Click \n               		  <span class=\"MenuCascade\" id=\"GUID-5E43FEAB-4B9E-48E9-906F-DF0DBEE1AFBC\">Create</span>. \n               		\n            </li>\n            <li>In the<span class=\"MenuCascade\" id=\"GUID-2DE55063-74C1-47E7-B514-A107552F8F04\"> Outliner</span>, rename the new nParticle object to \n               		  <em class=\"mild\">nParticle_slag</em>. \n               		\n            </li>\n         </ol>\n         <p><a name=\"WS73099CC142F48755-191A86AC126720FA35435F3\"></a>Next, position the emitter_slag object at the end of the spout (geo_slag_bin_spout)\n            so that the slag appears to pour from the bin onto the slag chute. \n            	 \n         </p><a name=\"WS73099CC142F48755-191A86AC126720FA35435F4\"></a><p class=\"list-intro\"><a name=\"WS73099CC142F48755-191A86AC126720FA35435F5\"></a>To position and set the emitter\n         </p>\n         <ol type=\"1\" start=\"1\">\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-4DC8553D-2DBA-484E-B1CF-2A3814F7C476\">Outliner</span> select the emitter_slag object. \n               		\n            </li>\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-72EE54FA-6911-4CF3-B375-618D270EF62C\">Channel Box</span> enter the following values: \n               		  <a name=\"WS73099CC142F48755-191A86AC126720FA35435F9\"></a><ul>\n                  <li><span class=\"MenuCascade\" id=\"GUID-8424F29D-34CD-44BA-96FD-D2FEB2F66F6F\">Translate X</span>: -9.0 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-0E6FCE50-71E9-40AB-AEED-584E70A17F70\">Translate Y</span>: 12.8 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-B93C8660-E9BF-44C6-B6B2-EB788939CDB8\">Translate Z</span>: -2.8 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-72E93884-20D5-4CD8-A8D6-AD52ACFB457D\">Rotate Y</span>: -23.6 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-558057CD-CD74-43FF-9AD4-4A5B29BD37EF\">Scale X</span>: 0.7 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-6CAFE94B-1D1F-4268-9485-3B3159F5D2B2\">Scale Y</span>: 0.7 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-AC40E45C-C48F-432A-B88D-2C661769D18C\">Scale Z</span>: 0.7 \n                     			 \n                  </li>\n               </ul> \n               <p><a name=\"WS73099CC142F48755-191A86AC126720FA3543601\"></a>For this simulation, only a brief stream of nParticles is necessary, rather than a\n                  continuous flow. To create the slag stream, you key the emitter_slag object so that\n                  it stops emitting particles at frame 85. This produces enough slag to slide down the\n                  chute and into the tub before the simulation ends. \n                  		  \n               </p> \n            </li>\n            <li>Rewind the simulation to the start frame. \n               		\n            </li>\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-93868C24-EFAF-46FA-8697-3E174C1F621A\">Channel Box</span>, set \n               		  <span class=\"MenuCascade\" id=\"GUID-037A615E-C11B-469E-9E1D-BD079F52EE05\">Rate</span> to 100. \n               		\n            </li>\n            <li>Right-click \n               		  <span class=\"MenuCascade\" id=\"GUID-712FCB4C-FEEA-4301-ACC8-F1698150AA58\">Rate</span> and select \n               		  <span class=\"MenuCascade\" id=\"GUID-5684E27B-BCB5-41C4-8EB6-E920A576577C\">Key Selected</span> from the pop-up menu. \n               		  \n               <p><a name=\"WS73099CC142F48755-191A86AC126720FA3543604\"></a>A keyframe is added to the Time slider. \n                  		  \n               </p> \n            </li>\n            <li>Play the simulation to frame 85, right-click \n               		  <span class=\"MenuCascade\" id=\"GUID-A3AE24C3-B2B8-46FF-B8DA-EFA83F6D46C1\">Rate</span> and select \n               		  <span class=\"MenuCascade\" id=\"GUID-12D30C71-86C2-4FBC-9723-BDFCBD98AD0D\">Key Selected</span>. \n               		\n            </li>\n            <li>Step the simulation forward one frame and in the \n               		  <span class=\"MenuCascade\" id=\"GUID-7FD4D03A-EF60-4002-A4C4-DE5E80838207\">Channel Box</span>, set \n               		  <span class=\"MenuCascade\" id=\"GUID-FAFE96AB-589A-4F10-92D0-3F1FB5FD015B\">Rate</span> to 0. \n               		\n            </li>\n            <li>Right-click on \n               		  <span class=\"MenuCascade\" id=\"GUID-6156C103-D49F-4E08-92F7-BDC02F30A582\">Rate</span> and create another keyframe. \n               		\n            </li>\n            <li>Play the simulation. \n               		  \n               <p><a name=\"WS73099CC142F48755-191A86AC126720FA3543609\"></a>Most nParticles emit onto the chute, slide down the incline, and land in the slag\n                  tub. Notice that some of the nParticles fall off the chute and land on the foundry\n                  floor. \n                  		  \n               </p> <a name=\"WS73099CC142F48755-5DCDA9B6127315F9A85-76E4\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-E18D4B7D-B28F-47BB-89F2-72E862F5E792-low.png\"></div> \n               <p><a name=\"WS73099CC142F48755-191A86AC126720FA354360A\"></a>Since you will later convert the nParticles to an output mesh, you want to ensure\n                  that no particles move too far away from the location of the nParticle mass as this\n                  enlarges the bounding box area of the resulting mesh. The \n                  			 <span class=\"MenuCascade\" id=\"GUID-229F3169-90B7-4E8C-845F-F8C1D2D1A002\">Output Mesh</span> <span class=\"MenuCascade\" id=\"GUID-33531076-39E2-47A1-A9AC-486574A31A17\">Max Triangle Resolution</span> defines the area of the mesh bounding box. \n                  		  \n               </p> \n               <p><a name=\"WS1A9193826455F5FF4E544F0312754F1F577-7CCD\"></a>If stray nParticles cause the bounding regions of the mesh to grow beyond the area\n                  set by \n                  			 <span class=\"MenuCascade\" id=\"GUID-634D0303-C29E-4DED-8C29-ACAB0CC5E998\">Max Triangle Resolution</span>, Maya increases the \n                  			 <span class=\"MenuCascade\" id=\"GUID-3B46BEE4-4A4A-4DC0-BD22-3070AA95314A\">Mesh Triangle Size</span> to compensate. A sudden increase in \n                  			 <span class=\"MenuCascade\" id=\"GUID-8B42D8CC-6926-4636-AA74-5C15A6358AFF\">Mesh Triangle Size</span> can quickly reduce the quality of the mesh and distort its appearance. The distortions\n                  in the mesh are often seen as flickering or popping on the mesh surface. For this\n                  reason, nParticle output meshes work best for small scale effects, such as liquid\n                  flows that do not cover a large area of the scene. \n                  		  \n               </p> \n               <p><a name=\"WS73099CC142F4875516078EA312754F1D2D4-7778\"></a>For information about \n                  			 <span class=\"MenuCascade\" id=\"GUID-C96ACA4E-4E7F-4CC7-A568-554D0AE350F0\">Max Triangle Resolution</span> and \n                  			 <span class=\"MenuCascade\" id=\"GUID-74C37E01-F6BC-4086-8BB6-CD996AD7C389\">Mesh Triangle Size</span>, see \n                  			 <em class=\"mild\">Output Mesh</em> in the \n                  			 <em class=\"mild\">nParticleShape node</em> section of the \n                  			 <em class=\"mild\">nDynamics</em> Help. \n                  		  \n               </p> \n            </li>\n         </ol>\n         <p><a name=\"WS1A9193826455F5FF45564F421269B08A8E9-7F72\"></a>In this section of the lesson, you turn down the \n            		<span class=\"MenuCascade\" id=\"GUID-2D7A9E43-C384-4231-AF4A-718F59ACE4F3\">Bounce</span> attribute so that the particles have no additional inertia making them fall off the\n            slag chute. \n            	 \n         </p><a name=\"WS1A9193826455F5FF45564F421269B08A8E9-7F71\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF45564F421269B08A8E9-7F70\"></a>To set Bounce\n         </p>\n         <ol type=\"1\" start=\"1\">\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-8E1DFE19-083B-47A3-B52F-342DA6350F1E\">Outliner</span>, select \n               		  <em class=\"mild\">nParticle_slag</em>. \n               		\n            </li>\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-3996C8AF-9935-4B4F-A9C7-54092B39C80C\">Attribute Editor</span>, switch to the \n               		  <span class=\"MenuCascade\" id=\"GUID-2D87EF8E-5F22-4FA2-AB3E-A988FBB2C6F1\">nParticle_slagShape</span> tab, and in the \n               		  <span class=\"MenuCascade\" id=\"GUID-B33D3B27-EF91-4183-897F-8DB22B1F7839\">Collisions</span> section, set \n               		  <span class=\"MenuCascade\" id=\"GUID-86B6B74B-68E4-408C-B584-92F0A6CACEFC\">Bounce</span> to 0. \n               		\n            </li>\n            <li>Rewind the simulation and play it back. \n               		  \n               <p><a name=\"WS1A9193826455F5FF45564F421269B08A8E9-7F68\"></a>With \n                  			 <span class=\"MenuCascade\" id=\"GUID-518B9EAD-8761-47A9-9014-B6D5B36FE926\">Bounce</span> at 0, the nParticles stay on the slag chute. Also, the particles are causing some\n                  side-to-side movement, which will make the texture look more realistic when applied.\n                  \n                  		  \n               </p> <a name=\"WS73099CC142F48755-5DCDA9B6127315F9A85-76E3\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-32AA2173-5501-4F68-9E05-06812AA9A6B5-low.png\"></div> \n               <p><a name=\"WS73099CC142F48755-5DCDA9B6127315F9A85-76E2\"></a>If the problem with particles escaping persists after you turn down the \n                  			 <span class=\"MenuCascade\" id=\"GUID-9E728AE0-0814-4E78-9F23-006C22A0A307\">Bounce</span>, you can use either \n                  			 <span class=\"MenuCascade\" id=\"GUID-34E82EEC-B909-46C6-9FA2-3A845D94A345\">Friction</span> or \n                  			 <span class=\"MenuCascade\" id=\"GUID-35E9B5F2-789B-45E6-8E66-0DBC364CAC20\">Stickiness</span> to further stabilize the particles on the chute. \n                  		  \n               </p> \n            </li>\n         </ol>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";